<?php
/* --------------------------------------------------------------
   configuration_gx.php 2020-20-24
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 07 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

use Gambio\Admin\Application\Kernel\AdminBootstrapper;
use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Core\Application\ValueObjects\UserPreferences;
use Gambio\Core\Configuration\Controller\LegacyConfigurationController;
use Gambio\Admin\Customer\SimpleCustomerService;
use Gambio\Core\Application\Application;
use Gambio\Core\Application\Kernel\HttpKernel;
use Slim\Factory\ServerRequestCreatorFactory;
use Slim\Psr7\Factory\StreamFactory;
use Slim\ResponseEmitter;

ini_set('display_errors', '1');

require_once __DIR__ . '/../system/classes/security/PageToken.inc.php';
require_once __DIR__ . '/../system/core/logging/LogControl.inc.php';
require_once __DIR__ . '/../vendor/autoload.php';

$kernel       = new HttpKernel();
$application  = new Application();
$bootstrapper = new AdminBootstrapper();
$kernel->bootstrap($application, $bootstrapper);

/**
 * @var SimpleCustomerService $customerService
 * @var UserPreferences       $userPreferences
 * @var Url                   $url
 */
$customerService = $application->get(SimpleCustomerService::class);
$userPreferences = $application->get(UserPreferences::class);
$url             = $application->get(Url::class);

if (!$userPreferences->isCustomer()
    || !$customerService->isAdmin($userPreferences->customerId())) {
    $serverRequestCreator = ServerRequestCreatorFactory::create();
    $request              = $serverRequestCreator->createServerRequestFromGlobals();
    
    $response = new \Slim\Psr7\Response(301);
    $response = new \Slim\Http\Response($response, new StreamFactory());
    
    header('Location: ' . $url->base() . '/login.php');
    die;
}

/** @var LegacyConfigurationController $controller */
$controller = $application->get(LegacyConfigurationController::class);

$serverRequestCreator = ServerRequestCreatorFactory::create();
$request              = $serverRequestCreator->createServerRequestFromGlobals();

$response = new \Slim\Psr7\Response(200);
$response = new \Slim\Http\Response($response, new StreamFactory());

$response        = $controller->displayConfigurations($request, $response, ['groupId' => $_GET['gID'] ?? '1']);
$responseEmitter = new ResponseEmitter();

$responseEmitter->emit($response);
